/*
    Empire.h
    Mark T. Collins 4/10/92

    4/10/92 - localized all structures into .h file...  we're getting big!

*/

#pragma	lint		3
#pragma	memorymodel	0
#pragma	optimize	-1

#define DBUG(x) asm { brk x }

#include	<Types.h>
#include	<Control.h>
#include	<List.h>
#include	<Menu.h>
#include	<Quickdraw.h>
#include	<QDAux.h>
#include	<TextEdit.h>
#include	<Window.h>
#include	<Foundation.h>

/*
Windows-
Resource Numbers
0x00300		Window Color Editor
0x00500		Window Editor
0x00550		Key Equivalents
0x00600		Control Color Editor
0x00700		Menu Bar Editor
0x00800		Menu/Menu Item Editor
0x00900		List Editor
0x10001		Simple Button Control Editor
0x10002		Check Box Control Editor
0x10003		Icon Button Control Editor
0x10004		Line Edit Control Editor
0x10005		Radio Box Control Editor
0x10006		List Control Editor
0x10007		Picture Control Editor
0x10008		PopUp Menu Control Editor
0x10009		Scroll Bar Control Editor
0x1000A		Size Box Control Editor
0x1000B		Static Text Control Editor
0x1000C		Text Edit Control Editor
0x1000D		Thermometer Control Editor
0x1000E		Rectangle Control Editor

Kinds-
	Window          0
    AlertWindow		1     This one is only a reference for the Color Editors
	Check Box       2
	Radio Button	3
	Simple Button   4
	Icon Button     5
	List            6
	Pop-Up Menu		7
	Scroll Bar		8
	Grow Box		9
	Edit Text		10
	Thermometer		11
	Edit Line       12
	Picture			13
	Static Text		14
	Rectangle		15
	ControlList     16
	ControlColor	17
	WindowColor     18
	MenuBar			19
	Menu			20
	MenuItem		21

Col #		640 Color		320 Color
	0		Black			Black
	1		Navy Blue		Dark Gray
	2		Khaki			Maroon
	3		Gray 1			Dk Blue
	4		Red				Blue
	5		Purple			Green
	6		Orange			Red
	7		Pink			Dk Red
	8		Green			Orange
	9		Forest Green	Yellow
	A		Lt Green 1		Lt Green
	B		Lt Green 2		Aqua
	C		Gray 2			Puce
	D		Periwinkle Blue	Blue 2
	E		Yellow			Lt Gray
	F		White			White

These are the rects to be used by the various color editors...
CONTROLS-

CheckBox, Radio Button (BoxColors)
            Foreground              Background
Normal  -   1  [0] Nor:3-0          2  [1] Nor:7-4
Selected-   3  [3] Sel:3-0          4  [4] Sel:7-4
Title-      4  [2] Title:3-0        6  [5] Title:7-4

SimpleButton, Icon Button  (ButtonColors)
            Foreground              Background
Normal  -   1  [0] Outline:7-4      2  [1] NorBack:7-4  & NorText:7-4
Selected-                           4  [4] SelBack:7-4  & SelText:7-4
NorText-    5  [2] NorText:3-0
SelText-    7  [3] SelText:3-0

List Control (ListColors)
            Foreground              Background
Frame       1  [0] Frame:3-0
NorText     3  [2] NorText:3-0      4  [1] NorBack:3-0
SelText     5  [3] SelText:3-0      6  [4] SelBack:3-0

PopUpMenu (MenuColors)
            Foreground              Background
Outline     1  [0] Outline:3-0
NorText     3  [2] NorText:3-0      4  [1] NorText:7-4
HiText      5  [3] HiText:3-0       6  [4] HiText:7-4

Scroll Bar (ScrollColors)
            Foreground              Background
ScrollBar   1  [0] Outline:7-4      2  [1] ArrowBack:7-4 & Inactive:7-4
NorArrow    3  [2] NorArrow:3-0     4  [5] NorArrow:7-4 & NorThumb:7-4
SelArrow    5  [3] SelArrow:3-0     6  [4] SelArrow:7-4
PageRgn     7  [6] PageRgn:3-0      8  [7] PageRgn:7-4
    NOTE- if 7 & 8 are different, set PageRgn b8

SizeBox (SizeColors) [3]
            Foreground              Background
Outline     1  [0] Outline:7-4
Rectangle   3  [2] NorBack:3-0      4  [1] NorBack:7-4

TextEdit (TEColors) [4]
            Foreground              Background
Rectangle   1  [0] Outline:3-0      2  [1] Content:3-0
  The rest is dispatched to scrollbar & sizebox editors

ThemoBar (ThermColors) [3]
            Foreground              Background
Control     1  [0] Outline:3-0      2  [1] Interior:3-0
Thermometer 3  [3] ForeGnd:3-0      4  [4] BackGnd:3-0
    NOTE- if 3 & 4 are different, set BackGnd b15

WINDOW
            Foreground              Background
Frame       1! [0] frameColor:7-4
			2  [1] titleColor:3-0   3  [2] tBarColor: 3-0
			4  [3] tBarColor: 7-4
			5  [4] titleColor:11-8  6  [5] titleColor:7-4
			7  [6] growColor: 7-4   8  [7] growColor: 3-0
			9  [8] infoColor: 7-4
            A^ [9] growColor: 15-12 B^ [A] infoColor: 15-12
               ! - Used in Alerts & Normal Windows
               ^ - Used in Alerts Only
                   otherwise used in normal windows only

ICON HILITE

*/

union control {
	Pointer					dummy;
	SimpleButtonTemplate	*BcPtr;
	CheckBoxTemplate		*CBcPtr;
	IconButtonTemplate		*IcPtr;
	LineEditTemplate		*LEcPtr;
	ListTemplate			*LcPtr;
	PictureTemplate			*PcPtr;
	PopupTemplate			*PMcPtr;
	RectangleTemplate		*RcPtr;
	ScrollBarTemplate		*SBcPtr;
	SizeBoxTemplate			*GcPtr;
	StaticTextTemplate		*STcPtr;
	TextEditTemplate		*TEcPtr;
	ThermometerTemplate		*TcPtr;
};
typedef union control control;

union ctlClr {
	Pointer			dummy;
	BoxColorsPtr	*BoCol;		/* Check Box, Radio Button */
	BttnColorsPtr	*BuCol;		/* Simple Button, Icon Button */
	LColorTablePtr	*LiCol;		/* List Control */
	MenuColorsPtr	*MeCol;		/* PopUpMenu */
	BarColorsPtr	*ScCol;		/* ScrollBar */
	SizeColorsPtr	*SiCol;		/* Size Box */
	TEColorTablePtr	*TECol;		/* Text Edit */
	ThermColorsPtr	*ThCol;		/* ThermoBar */
};
typedef union ctlClr ctlClr;

struct servant {
	word	numColors;
	word	cRect[9];
	word	color[9];
	word	numStrings;
	word	stringLoc[6];
	word	rString[6];
};
typedef struct servant servant;

union multiPtr {
	char	*Ptr;
	word	*wPtr;
	long	*lPtr;
};
typedef union multiPtr multiPtr;

/*  these are not defined, so we boldly go where noone seems to have gone...
                                                                before...  */
struct WinTemplate {
	word	plLength;
	word	plFrameBits;
	long	plTitle;
	long	plRefCon;
	Rect	plZoom;
	long	plColor;
	word 	plYOrigin;
	word	plXOrigin;
	word	plDataH;
	word	plDataW;
	word	plMaxH;
	word	plMaxW;
	word	plScrollVer;
	word	plScrollHor;
	word	plPageVer;
	word	plPageHor;
	long	plInfoText;
	word	plInfoHeight;
	long	plDefProc;
	long	plInfoDraw;
	long	plContentDraw;
	Rect	plPosition;
	long	plPlane;
	long	plControlList;
	word	plInDesc;
};
typedef struct WinTemplate WinTemplate, *WinTemplatePtr, **WinTemplateHndl;

struct MenuColors {
	word	NorText;	/* Normal text color /*
	word	HiText;		/* Hilited text color */
	word	Outline;	/* Outline color */
} ;
typedef struct MenuColors MenuColors, *MenuColorsPtr, **MenuColorsHndl;

struct SizeColors {
	Word	Outline;	/* color of outline */
	Word	NorBack;	/* color of background when not selected */
};
typedef struct SizeColors SizeColors, *SizeColorsPtr, **SizeColorsHndl;

struct ThermColors {
	word 	Outline;	/* Outline color bit 0-4 */
	word 	Interior;	/* Interior color bit 0-4 */
	word 	Foregnd;	/* Foreground color bit 0-4 */
	word 	Backgnd;	/* Background color bit 0-4, bit 15 if dotted pattern */
};
typedef struct ThermColors ThermColors, *ThermColorsPtr, **ThermColorsHndl;

typedef struct MenuTemplate *MenuTemplatePtr;
typedef struct MenuItemTemplate *MenuItemTemplatePtr;
typedef struct itemStruct *itemStructPtr;

/*	extraData for Menus....	*/
										/*	  Size		  Total	*/

struct privMenuBarRec {

word			count;					/*		2			2	*/
word			flag;					/*		2			4	*/
privMenuRec		Menu[]					/*		massive			*/
};
typedef struct privMenuBarRec privMenuBarRec, *privMenuBarRecPtr;


struct privMenuRec {
word			menuID;					/*		2			2	*/
word			count;					/*		5			4   */
char			*title;					/*		4			8	*/
privItemRecPtr	item[];					/*
};
typedef struct privMenuRec privMenuRec, *privMenuRecPtr;

struct privItemRec {

word			itemID;					/*		2			2	*/
byte			equiv1, equiv 2;		/*		2			4	*/
word			check;					/*		2			6	*/
word			flag;					/*		2			8	*/
char			*title;					/*		4		   12	*/
Pointer			icon;					/*		4		   16	*/
};
typedef struct privItemRec privItemRec, *privItemRecPtr;

struct privateData {							/* offset-datasize */
	word				dirty;					/*	00 + 2	*/
	Handle				data;					/*	02 + 4	*/
	Handle				title;					/*	06 + 4	*/
	GrafPortPtr			winP;					/*	10 + 4	*/
	GrafPortPtr			edP;					/*	14 + 4	*/
	WinTemplateHndl		edTempH;				/*	18 + 4	*/
	WinTemplateHndl		wkTempH;				/*	22 + 4	*/
	Handle				edCtlListH;				/*	26 + 4	*/
	Handle				wkCtlListH;				/*	30 + 4	*/
	Handle				edMenuBarH;				/*	34 + 4	*/
	Handle				wkMenuBarH;				/*	38 + 4	*
	Handle				edWinClrH;				/*	42 + 4	*/
	Handle				wkWinClrH;				/*	46 + 4	*/
	word				numCtls;				/*	50 + 2	*/
	word				windKind;				/*	52 + 2	*/
	word				parentKind;				/*	54 + 2	*/
	word				shortKind;				/*	56 + 2	*/
	long				parentID;				/*	58 + 4	*/
	handle				extraData;				/*	62 + 4	*/
	word				winPos;					/*	66 + 2  */
	word				winWidth;				/*	68 + 2  */
	word				masterColor[11]			/*  70 + 22 */
};										/*	total	92		*/
typedef struct privateData privateData, *privateDataPtr **privateDataHndl;

/* Master Color Translation table:
					Controls			Window                  IcnHilite
				[0] - Outline			Frame                   Foreground
				[1] - Nor Bkgnd			TitleBar			    Background
				[2] - Nor Text Frgnd 	TitleBar/MidFrameFrgnd		N/A
				[3] - Sel Frgnd			Pattern						N/A
				[4] - Sel Bkgnd			InactTBar Bkgnd				N/A
				[5] - Nor Text Bkgnd	InactTBar Frgnd				N/A
				[6] - Pat Frgnd			SizeBox Bkgnd				N/A
				[7] - Pat Bkgnd			SizeBox Frgnd				N/A
				[8] -  N/A				InfoBar Bkgnd				N/A
				[9] -  N/A				MidFrame Bkgnd				N/A
				[A] -  N/A				MidFrame Frgnd				N/A  */
